/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.NavAreaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.earth.TreeNodeIdManager;
import com.ibm.hwmca.ui.bonsai.earth.util.BonsaiRegurgitater;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.table.TreeTableModel;
import com.ibm.hwmca.ui.bonsai.tree.TreeEmptyException;
import com.ibm.hwmca.ui.bonsai.tree.TreeModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class BonsaiTreeManager {
    private static final String TRACEMASK_T = "XBUIMGRT";
    private static final String TRACEMASK_F = "XBUIMGRF";
    private static final String TRACEMASK_D = "XBUIMGRD";
    private static BonsaiTreeManager treeManager;
    private static NavAreaConfigBean configBean;
    private static Object lock;
    private List rootNodes;

    private BonsaiTreeManager(NavAreaConfigBean bean) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<> BonsaiTreeManager(" + bean + ")");
        this.rootNodes = BonsaiRegurgitater.getTrees(bean.getTrees(), bean.getNodes(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(NavAreaConfigBean bean) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<--> BonsaiTreeManager.init(" + bean + ")");
        Object object = lock;
        synchronized (object) {
            if (TreeNodeIdManager.getTreeNodeIdManager() == null) {
                throw new IllegalStateException("The TreeNodeIdManager must be initialized before the BonsaiTreeManager!");
            }
            if (TaskManager.getTaskManager() == null) {
                throw new IllegalStateException("The TaskManager must be initialized before the BonsaiTreeManager!");
            }
            if (treeManager == null) {
                configBean = bean;
                treeManager = new BonsaiTreeManager(bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildTree() throws BonsaiConfigException, IllegalStateException {
        Trace.trace(TRACEMASK_T, "<--> BonsaiTreeManager.rebuildTree()");
        Object object = lock;
        synchronized (object) {
            if (treeManager == null || configBean == null) {
                throw new IllegalStateException();
            }
            treeManager = new BonsaiTreeManager(configBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildBranch(BonsaiTreeNode node) throws BonsaiConfigException, IllegalStateException {
        Trace.trace(TRACEMASK_T, "--> BonsaiTreeManager.rebuildBranch(" + node + ")");
        Object object = lock;
        synchronized (object) {
            if (treeManager == null || configBean == null || node == null) {
                throw new IllegalStateException();
            }
            node.removeAllChildren();
            Iterator children = BonsaiRegurgitater.getTrees(node.getConfigBean().getChildren(), configBean.getNodes(), node).iterator();
            while (children.hasNext()) {
                node.addChild((BonsaiTreeNode)children.next());
            }
        }
        Trace.trace(TRACEMASK_T, "<-- BonsaiTreeManager.rebuildBranch()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BonsaiTreeManager getBonsaiTreeManager() {
        Object object = lock;
        synchronized (object) {
            return treeManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTreeModels(UISession session, Locale locale) {
        Object object = lock;
        synchronized (object) {
            ArrayList<TreeModel> models = new ArrayList<TreeModel>();
            Iterator iterator = this.rootNodes.iterator();
            while (iterator.hasNext()) {
                try {
                    models.add(new TreeModel((BonsaiTreeNode)iterator.next(), session, locale));
                }
                catch (TreeEmptyException teEx) {}
            }
            return models;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableModel getTableModel(String id, UISession session, Locale locale) {
        Object object = lock;
        synchronized (object) {
            BonsaiTreeNode node = this.getTreeNode(id);
            if (node == null) {
                return null;
            }
            return new TreeTableModel(node, session, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRootNodes() {
        Object object = lock;
        synchronized (object) {
            return this.rootNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BonsaiTreeNode getTreeNode(String id) {
        Object object = lock;
        synchronized (object) {
            return TreeNodeIdManager.getTreeNodeIdManager().getNode(id);
        }
    }

    public List getTreeNodes(List ids) {
        ArrayList<BonsaiTreeNode> nodes = new ArrayList<BonsaiTreeNode>();
        BonsaiTreeNode node = null;
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            node = this.getTreeNode((String)i.next());
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public List getTreeNodesByTreePath(String[] treePath) {
        return this.findNodes(this.rootNodes, treePath, 0);
    }

    private List findNodes(List nodes, String[] treePath, int level) {
        boolean lastRecursion = level == treePath.length - 1;
        ArrayList<BonsaiTreeNode> matches = new ArrayList<BonsaiTreeNode>();
        BonsaiTreeNode node = null;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            node = (BonsaiTreeNode)i.next();
            if (!node.getXMLKey().equals(treePath[level])) continue;
            if (lastRecursion) {
                matches.add(node);
                continue;
            }
            matches.addAll(this.findNodes(node.getChildren(), treePath, level + 1));
        }
        return matches;
    }

    static {
        lock = new Object();
    }
}

